package com.bxzk.afxj.DaggerComponent.Module;


import com.bxzk.afxj.retrofit.DownloadUtils;
import com.bxzk.afxj.retrofit.RxDownloadInterceptor;
import com.bxzk.afxj.retrofit.RxDownloadListener;

import javax.inject.Named;
import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

@Module
public class OkhttpModule {
    private RxDownloadListener listener;
    public OkhttpModule(RxDownloadListener listener) {
        this.listener = listener;
    }

    public OkhttpModule() {
    }

    @Singleton
    @Provides
    public DownloadUtils providerDownUtils(Retrofit retrofit) {
        return new DownloadUtils(listener,retrofit);
    }

    @Singleton
    @Provides
    @Named("down")
    public OkHttpClient providerDownOkhttpClient() {
        RxDownloadInterceptor mInterceptor = new RxDownloadInterceptor(listener);
      /*  HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);*/
        OkHttpClient client = new OkHttpClient.Builder()
                //添加应用拦截器
                .addInterceptor(mInterceptor)
                //添加网络拦截器
//                .addNetworkInterceptor(interceptor)
                .build();
        return client;
    }



}
