package com.bxzk.afxj.DaggerComponent.Module;

import javax.inject.Named;
import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class RetrofitModule {
    @Singleton
    @Provides
    public Retrofit providerRetrofit(@Named("default")OkHttpClient okHttpClient) {
       return new Retrofit.Builder()
                .baseUrl("http://www.wanandroid.com/blogimgs/")
                //将client与retrofit关联
                .client(okHttpClient)
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
                .build();

    }

}
