package com.bxzk.afxj.Manage;

import android.app.Activity;

import java.util.ArrayList;
import java.util.List;

/**
 * 创建人 Daniel
 * 时间   2018/11/1.
 * 简介   xxx
 */
public class ActivityManager {
    private static ActivityManager CLASS_NAME;
    public static List<Activity> activities = new ArrayList<>();



    public static synchronized ActivityManager getInstance() {
        if (CLASS_NAME == null) {
            synchronized (ActivityManager.class) {
                if (CLASS_NAME == null) {
                    CLASS_NAME = new ActivityManager();
                }
            }
        }
        return CLASS_NAME;
    }


    public void addActivity(Activity activity) {
        activities.add(activity);
    }

    public void finishActivity(Activity activity) {
        activity.finish();
    }

    public void removeActivity(Activity activity) {
        activities.remove(activity);
    }
    public void removeAllActivity() {
        for (Activity activity : activities) {
            activity.finish();
        }
    }

    public void finishActivityByName(String activityName) {
        for (Activity activity : activities) {
            if (activity.getClass().getSimpleName().equals(activityName)) {
                activity.finish();
                return;
            }
        }
    }




    public void finishActivities(int num) {
        for (int i = activities.size() - num - 1; i < activities.size(); i++) {
            activities.get(i).finish();
        }
    }
}
