package com.bxzk.afxj.Presenter;

import com.bxzk.afxj.Contract.LoginContract;
import com.bxzk.afxj.Entity.LoginBeanOut;
import com.bxzk.afxj.Model.LoginModel;
import com.bxzk.afxj.View.BaseActivity.BasePresenter;
import com.bxzk.afxj.retrofit.SimpleSubscriber;
import com.bxzk.afxj.util.SPULoginUtil;

import javax.inject.Inject;

import io.reactivex.Observable;

public class LoginPresenter extends BasePresenter<LoginContract.View> {
    @Inject
    LoginModel model;


    @Inject
    public LoginPresenter() {
        model = new LoginModel();
    }

    public void login(String info) {
        Observable<LoginBeanOut> loginObs = model.login(info);
        loginObs.compose(getView().bindLifecycle()).subscribe(new SimpleSubscriber<LoginBeanOut>() {
            @Override
            public void call(LoginBeanOut loginBeanOut) {
                getView().onLogin(loginBeanOut);
                SPULoginUtil.saveLogin1(loginBeanOut);
            }
        });
    }







}
