package com.bxzk.afxj.View.BaseActivity;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.trello.rxlifecycle2.components.support.RxAppCompatActivity;
import com.bxzk.afxj.R;
import com.bxzk.afxj.util.ToastUtils;

import java.util.ArrayList;
import java.util.List;

import cn.bingoogolapple.swipebacklayout.BGASwipeBackHelper;


public abstract class BaseActivity extends RxAppCompatActivity implements BGASwipeBackHelper.Delegate {
    private boolean isAlive = false;

    private static final int PERMISSION_CODE = 1010;

    private List<String> mPermission;
    private boolean mContinueRequest = false;

    private int mRequestCount = 0;
//    protected List<String> threadNameList;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        initSwipeBackFinish();
        super.onCreate(savedInstanceState);
        super.setContentView(setBaseContextView());

        initFirst();
//        threadNameList = new ArrayList<String>();
        initView(savedInstanceState);
        Log.e("TAG","CLASSNAME"+getClass().getSimpleName());
    }



    protected abstract void initFirst();

    protected abstract int setBaseContextView();

    //初始化所有控件
    public abstract void initView(@Nullable Bundle savedInstanceState);


    @Override
    protected void onStart() {
        super.onStart();

    }



    @Override
    protected void onDestroy() {

        super.onDestroy();
        isAlive = false;
//        threadNameList = null;
//        ThreadManager.getInstance().destroyThread(threadNameList);

    }

    /**
     * @param continueRequest 是否持续请求
     * @param permissions     需要请求的权限
     */
    public void requestBasePermissions(boolean continueRequest, String... permissions) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (mRequestCount >= 3){
                ToastUtils.showToast(this, R.string.open_setting);
                Intent intent = new Intent();
                intent.setAction(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
                Uri uri = Uri.fromParts("package", getPackageName(), null);
                intent.setData(uri);
                startActivityForResult(intent, 200);
            }
            mContinueRequest = continueRequest;
            for (String permission : permissions) {
                if (checkSelfPermission(permission) != PackageManager.PERMISSION_GRANTED) {
                    if (mPermission == null) {
                        mPermission = new ArrayList<>();
                    }
                    mPermission.add(permission);
                }
            }
            if (mPermission != null && mPermission.size() > 0) {
                String[] strings = new String[mPermission.size()];
                requestPermissions(mPermission.toArray(strings), PERMISSION_CODE);
                mRequestCount ++ ;
            }else{
                requestPermissionSuccess();
            }
        }else{
            requestPermissionSuccess();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == PERMISSION_CODE) {
            mPermission.clear();
            if (grantResults.length > 0) {
                List<String> dangerPermissions = new ArrayList<>();
                for (int i = 0; i < grantResults.length; i++) {
                    if (grantResults[i] != PackageManager.PERMISSION_GRANTED) {
                        dangerPermissions.add(permissions[i]);
                    }
                }
                dangerPermission(dangerPermissions);
            } else {
                requestPermissionSuccess();
            }
        }
    }

    public void dangerPermission(List<String> dangerPermissions) {
        if (mContinueRequest) {
            requestBasePermissions(true, dangerPermissions.toArray(new String[dangerPermissions.size()]));
        } else {
            for (String dangerPermission : dangerPermissions) {
            }
        }
    }

    public void requestPermissionSuccess(){

    }

    protected BGASwipeBackHelper mSwipeBackHelper;

    private void initSwipeBackFinish() {
        mSwipeBackHelper = new BGASwipeBackHelper(this, this);

        // 「必须在 Application 的 onCreate 方法中执行 BGASwipeBackHelper.init 来初始化滑动返回」
        // 下面几项可以不配置，这里只是为了讲述接口用法。

        // 设置滑动返回是否可用。默认值为 true
        mSwipeBackHelper.setSwipeBackEnable(true);
        // 设置是否仅仅跟踪左侧边缘的滑动返回。默认值为 true
        mSwipeBackHelper.setIsOnlyTrackingLeftEdge(false);
        // 设置是否是微信滑动返回样式。默认值为 true
        mSwipeBackHelper.setIsWeChatStyle(true);
        // 设置阴影资源 id。默认值为 R.drawable.bga_sbl_shadow
//        mSwipeBackHelper.setShadowResId(R.drawable.bga_sbl_shadow);
        // 设置是否显示滑动返回的阴影效果。默认值为 true
        mSwipeBackHelper.setIsNeedShowShadow(true);
        // 设置阴影区域的透明度是否根据滑动的距离渐变。默认值为 true
        mSwipeBackHelper.setIsShadowAlphaGradient(true);
        // 设置触发释放后自动滑动返回的阈值，默认值为 0.3f
        mSwipeBackHelper.setSwipeBackThreshold(0.3f);
        // 设置底部导航条是否悬浮在内容上，默认值为 false
        mSwipeBackHelper.setIsNavigationBarOverlap(false);
    }

    /**
     * 是否支持滑动返回。这里在父类中默认返回 true 来支持滑动返回，如果某个界面不想支持滑动返回则重写该方法返回 false 即可
     *
     * @return
     */
    @Override
    public boolean isSupportSwipeBack() {
        return false;
    }

    /**
     * 正在滑动返回
     *
     * @param slideOffset 从 0 到 1
     */
    @Override
    public void onSwipeBackLayoutSlide(float slideOffset) {
        Log.e("yunxun","slideOffset:"+slideOffset);
    }

    /**
     * 没达到滑动返回的阈值，取消滑动返回动作，回到默认状态
     */
    @Override
    public void onSwipeBackLayoutCancel() {
    }

    /**
     * 滑动返回执行完毕，销毁当前 Activity
     */
    @Override
    public void onSwipeBackLayoutExecuted() {
        mSwipeBackHelper.swipeBackward();
    }

    @Override
    public void onBackPressed() {
        // 正在滑动返回的时候取消返回按钮事件
        /*if (mSwipeBackHelper.isSliding()) {
            return;
        }
        mSwipeBackHelper.backward();*/
        super.onBackPressed();

    }
}
