package com.bxzk.afxj.View.BaseActivity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.trello.rxlifecycle2.components.support.RxFragment;
import com.bxzk.afxj.DaggerComponent.MainComponent;
import com.bxzk.afxj.DaggerComponent.MainModule;
import com.bxzk.afxj.R;
import com.bxzk.afxj.application.BApplication;

import javax.inject.Inject;

import butterknife.ButterKnife;
import butterknife.Unbinder;

public abstract class BaseFragment<V,T extends BasePresenter<V>>  extends RxFragment {
    private int resId;
    protected View view;
    private Unbinder binder;
    protected Activity activity;
    private boolean isAlive;
    private BaseActivity context = null;
    private boolean isRunning;
    private boolean isBindData;

    protected LinearLayout ll_content;
    private View mContentView;
   public View emptyvie;
    @Inject
    protected T fPresenter;
    private boolean isVisible;//是否可见

    public BaseFragment() {
    }



    protected MainComponent getActivityComponent() {
        return  BApplication.getBaseComponent().addSub(new MainModule(this));
    }


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        isAlive = true;
        context = (BaseActivity) getActivity();
        inject();
        if(null != fPresenter) {
            fPresenter.attachView((V)this);
        }
        if (resId == 0) {
//            emptyvie = View.inflate(context, R.layout.emptyview_data, null);

            mContentView = View.inflate(context, setBaseContextView(), null);
            binder = ButterKnife.bind(this, mContentView);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            mContentView.setLayoutParams(layoutParams);
            ll_content.addView(mContentView);
            initView();
            initListener();
            initValue();

        } else {
            view = null;
        }
        return view;
    }

    protected abstract void inject();

    protected abstract int setBaseContextView();

    public Context getContext() {
        if (activity == null) {
            return BApplication.getInstances();
        }
        return activity;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        activity = getActivity();
    }

    protected abstract void initValue();

    protected void initListener() {

    }

    protected abstract void initView();

    public final boolean isAlive() {
        return isAlive && context != null;// & ! isRemoving();导致finish，onDestroy内runUiThread不可用
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if(null != fPresenter){
            fPresenter.detachView();
        }
        binder.unbind();
    }

    @Override
    public void onPause() {
        super.onPause();
        isRunning = false;
    }

    @Override
    public void onResume() {
        super.onResume();
        isRunning = true;
    }

    @Override
    public void onDestroy() {

        if (view != null) {
            try {
                view.destroyDrawingCache();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        isAlive = false;
        isRunning = false;
        super.onDestroy();
        view = null;
        context = null;

    }

    /**快捷显示short toast方法，需要long toast就用 Toast.makeText(string, Toast.LENGTH_LONG).show(); ---不常用所以这个类里不写
     * @param string
     */
    public void showShortToast(String string) {
        if (isAlive() == false) {
            return;
        }
    }
    public void requestBasePermissions(boolean continueRequest, String... permissions) {
        if (isAlive() == false) {
            return;
        }
        context.requestBasePermissions(continueRequest,permissions);
    }


    protected  View removeContent() {
        ll_content.removeView(mContentView);
        return mContentView;
    }

    protected void recoverContent() {
        ll_content.addView(mContentView);
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);

        if(getUserVisibleHint()) {
            isVisible = true;
            onVisible();
        } else {
            isVisible = false;
            onInvisible();
        }
    }

    /**
     * 可见
     */
    protected void onVisible() {
//        lazyLoad();
    }

    /**
     * 不可见
     */
    protected void onInvisible() {
    }

    //网络请求 在切换tab调用
    public void netReq() {
    }


}
