package com.bxzk.afxj.View.BaseActivity;

import android.content.Context;

import com.bxzk.afxj.application.BApplication;

import java.lang.ref.WeakReference;

public abstract class BasePresenter<T> {

    protected Context mContext = BApplication.getContext();

    protected WeakReference<T> mViewInterface;

    public void attachView(T view) {
            mViewInterface = new WeakReference<T>(view);
    }

    public T getView() {
        return mViewInterface.get();
    }

    public boolean isAttached() {
        return mViewInterface != null && mViewInterface.get() != null;
    }

    public void detachView() {
        if(mViewInterface != null) {
            mViewInterface.clear();
//            OkGo.getInstance().cancelTag(getView());
            mViewInterface = null;
        }
    }
}
