package com.bxzk.afxj.View.demo;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;

import androidx.appcompat.widget.AppCompatButton;

import java.util.Timer;
import java.util.TimerTask;


public class VerifyButton extends AppCompatButton {
    private int timess;
    private TimerTask timerTask;
    private Timer timer;
    private boolean noFirst;
    public final static int FSEND = 1;//首次发送
    public final static int RSEND = 2;//重新发送

    private OnStatusChange onStatusChange;

    public void setOnStatusChange(OnStatusChange onStatusChange) {
        this.onStatusChange = onStatusChange;
    }

    public interface OnStatusChange {
        void statusChange(View v, int status);
    }

    public VerifyButton(Context context) {
        this(context,null);
    }

    public VerifyButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void initClick() {
        this.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {

                initClickContent(v);
            }
        });
    }

    public void startTimer(){
        timess = 120;
        this.setText(timess+"s");
        if(timerTask==null){
            timerTask = new TimerTask() {
                @Override
                public void run() {
                    post(new Runnable() {
                        @Override
                        public void run() {
                            VerifyButton.this.setText(timess+"s");
                            timess--;
                            if(timess<=0){
                                stopTimer();
                                VerifyButton.this.setText("重新获取");
                                VerifyButton.this.setClickable(true);
                                if(onStatusChange != null) {
                                    onStatusChange.statusChange(VerifyButton.this,RSEND);
                                }
                                noFirst = true;
                                return;
                            }
                        }
                    });

                }
            };
        }
        if(timer==null){
            timer = new Timer();
        }
        timer.schedule(timerTask, 0, 1000);
    }

    public void initClickContent(View v) {
        if(null !=onStatusChange) {
            if(!noFirst) {
                onStatusChange.statusChange(v,FSEND);
            }else {
                onStatusChange.statusChange(v,RSEND);
            }


        }
        startTimer();
        VerifyButton.this.setClickable(false);
    }

    public void stopTimer(){
        if(timer!=null){
            timer.cancel();
            timer=null;
        }
        if(timerTask!=null){
            timerTask.cancel();
            timerTask=null;
        }

    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        stopTimer();
    }
}
