package com.bxzk.afxj.application;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.StrictMode;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatDelegate;

import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.squareup.leakcanary.LeakCanary;
import com.tencent.bugly.Bugly;
import com.tencent.bugly.beta.Beta;
import com.tencent.bugly.beta.interfaces.BetaPatchListener;
//import com.umeng.commonsdk.UMConfigure;
//import com.umeng.commonsdk.statistics.common.DeviceConfig;
//import com.umeng.message.IUmengRegisterCallback;
//import com.umeng.message.MsgConstant;
//import com.umeng.message.PushAgent;
//import com.umeng.message.UTrack;
//import com.umeng.message.UmengMessageHandler;
//import com.umeng.message.UmengNotificationClickHandler;
//import com.umeng.message.entity.UMessage;
import com.bxzk.afxj.DaggerComponent.BaseComponent;
import com.bxzk.afxj.DaggerComponent.BaseModule;
import com.bxzk.afxj.DaggerComponent.DaggerBaseComponent;
import com.bxzk.afxj.DaggerComponent.Module.OkhttpModule;
import com.bxzk.afxj.Manage.ActivityManager;
import com.bxzk.afxj.R;
import com.bxzk.afxj.adapter.ScreenAdapter;
import com.bxzk.afxj.database.DaoManager;
import com.bxzk.afxj.util.DataKeeper;
import com.bxzk.afxj.util.SPUtils;
import com.bxzk.afxj.util.SettingUtil;

import java.util.HashMap;
import java.util.Map;

import cn.bingoogolapple.swipebacklayout.BGASwipeBackHelper;

import static com.bxzk.afxj.util.ToastUtils.showToast;

//import com.lzy.okgo.OkGo;
//import com.lzy.okgo.cache.CacheEntity;
//import com.lzy.okgo.cache.CacheMode;
//import com.lzy.okgo.https.HttpsUtils;
//import com.lzy.okgo.interceptor.HttpLoggingInterceptor;


public class BApplication extends Application {
    private static Context mContext;
    /* private DaoMaster mDaoMaster;
     private DaoSession mDaoSession;*/
    private SQLiteDatabase db;
    public static BApplication instances;
    ;
    private static Application instance;

    public static Application getInstance() {
        return instance;
    }

    //    private IWXAPI mWxApi;
    public static int count;
    private boolean wasOpened;
    private Handler handler;
    private static final String TAG = "yunxun";
    public static final String UPDATE_STATUS_ACTION = "com.umeng.message.example.action.UPDATE_STATUS";

    public static Context getContext() {
        return mContext;
    }

    public static BApplication getInstances() {
        return instances;
    }

    private static BaseComponent baseComponent;

    private float fontScale;

    //    @Keep
//    @SophixEntry(BApplication.class)
    static class RealApplicationStub {
    }


    @Override
    public void onCreate() {
        super.onCreate();
//        MultiDex.install(this);
//        initSophix();
        BGASwipeBackHelper.init(this, null);//初始化滑动
        com.bxzk.afxj.util.Log.d(TAG, "项目启动 >>>>>>>>>>>>>>>>>>>> \n\n");
        init(this);
//        setDatabase();
//        initX5WebView();
        mContext = getApplicationContext();
        instances = this;
        fontScale = getFontScale();
        ScreenAdapter.setup(this);
        ScreenAdapter.register(this, 375, ScreenAdapter.MATCH_BASE_HEIGHT, ScreenAdapter.MATCH_UNIT_DP);
//        initWxFacePay();
        DaoManager.getInstance().init(this);
        initRefreshParams();
//        MobSDK.init(this);
//        setNightMode();
        //bugly
        initHeightBugly();
//极光
       /* JPushInterface.setDebugMode(true);
        JPushInterface.init(this);*/
//       initUpush();
//        SpeechUtility.createUtility(this, SpeechConstant.APPID + "=5dd4e7b4");
//        ZXingLibrary.initDisplayOpinion(this);
//        UMConfigure.init(this, "5e61e0e5167edd124000053c", null, UMConfigure.DEVICE_TYPE_PHONE, "dd38f64aeee97cfaf56b24868bc25a97");
//        UMConfigure.setLogEnabled(true);
//        getTestDeviceInfo(this);

        setYouConfig();

        checkMemory();

//        catchException();

/*        MobSDK.init(this);
//        initOkGo();
        ZXingLibrary.initDisplayOpinion(this);
//        MobSDK.init(this);

        StreamingEnv.init(getApplicationContext());



        //融云
        ChatroomKit.init(mContext, "3argexb63q06e");*/

    }

    //捕获全局异常

    private void checkMemory() {
        if (LeakCanary.isInAnalyzerProcess(this)) {
            // This process is dedicated to LeakCanary for
            // heap analysis.
            // You should not init your app in this process.
            return;
        }

        LeakCanary.install(this);

    }

    private void initWxFacePay() {
        Map<String, String> m1 = new HashMap<>();
//      m1.put("ip", "192.168.1.1"); //若没有代理,则不需要此行
//      m1.put("port", "8888");//若没有代理,则不需要此行
//      m1.put("user", mEtnUser.getText().toString());//若没有代理,则不需要此行
//      m1.put("passwd", mEtnPassword.getText().toString());//若没有代理,则不需要此行
//      m1.put("proxy_type", 1 ); //若没有代理,则不需要此行
//      m1.put("perform_mode", "LOW_PERFORM");//低性能表现，默认关闭美颜等


    }

    private void setYouConfig() {

//        PlatformConfig.setWeixin("wxf6257c5a3dab8192", "cdcee5ca359271abf9ba9c98bf9cf389");
////        PlatformConfig.setWeixin("wxf6257c5a3dab8192", "cdcee5ca359271abf9ba9c98bf9cf389");
//        PlatformConfig.setQQZone("1109653713", "Iz1aUurVCdYCFahG");
//        PlatformConfig.setSinaWeibo("568898243", "38a4f8204cc784f81f9f0daaf31e02e3", "http://sns.whalecloud.com");


    }

    public void setNightMode(boolean isNight) {
        int mode = isNight ? AppCompatDelegate.MODE_NIGHT_YES : AppCompatDelegate.MODE_NIGHT_NO;
        AppCompatDelegate.setDefaultNightMode(mode);
    }
    /*public static IWXAPI mWxApi;
    private void registToWX() {
        //第二个参数是指你应用在微信开放平台上的AppID
        mWxApi = WXAPIFactory.createWXAPI(this, "wx4a33bb7accadf883", false);
        // 将该app注册到微信
        mWxApi.registerApp("wx4a33bb7accadf883");
    }*/

    //refreshlayout文字参数
    private void initRefreshParams() {
        ClassicsHeader.REFRESH_HEADER_PULLING = getString(R.string.header_pulling);//"下拉可以刷新";
        ClassicsHeader.REFRESH_HEADER_REFRESHING = getString(R.string.header_refreshing);//"正在刷新...";
        ClassicsHeader.REFRESH_HEADER_LOADING = getString(R.string.header_loading);//"正在加载...";
        ClassicsHeader.REFRESH_HEADER_RELEASE = getString(R.string.header_release);//"释放立即刷新";
        ClassicsHeader.REFRESH_HEADER_FINISH = getString(R.string.header_finish);//"刷新完成";
        ClassicsHeader.REFRESH_HEADER_FAILED = getString(R.string.header_failed);//"刷新失败";

        ClassicsFooter.REFRESH_FOOTER_PULLING = getString(R.string.footer_pulling);//"上拉加载更多";
        ClassicsFooter.REFRESH_FOOTER_RELEASE = getString(R.string.footer_release);//"释放立即加载";
        ClassicsFooter.REFRESH_FOOTER_LOADING = getString(R.string.footer_loading);//"正在刷新...";
        ClassicsFooter.REFRESH_FOOTER_REFRESHING = getString(R.string.footer_refreshing);//"正在加载...";
        ClassicsFooter.REFRESH_FOOTER_FINISH = getString(R.string.footer_finish);//"加载完成";
        ClassicsFooter.REFRESH_FOOTER_FAILED = getString(R.string.footer_failed);//"加载失败";
        ClassicsFooter.REFRESH_FOOTER_NOTHING = getString(R.string.footer_nothing);//"全部加载完成";

    }



   /* private void registToWX() {
        //AppPayConst.WEIXIN.APP_ID是指你应用在微信开放平台上的AppID，记得替换。
        mWxApi = WXAPIFactory.createWXAPI(this, AppPayConst.WEIXIN.APP_ID, false);
        // 将该app注册到微信
        mWxApi.registerApp(AppPayConst.WEIXIN.APP_ID);
    }*/

    /*private void initX5WebView() {
        //搜集本地tbs内核信息并上报服务器，服务器返回结果决定使用哪个内核。
        QbSdk.PreInitCallback cb = new QbSdk.PreInitCallback() {
            @Override
            public void onViewInitFinished(boolean arg0) {
                //x5內核初始化完成的回调，为true表示x5内核加载成功，否则表示x5内核加载失败，会自动切换到系统内核。
                Log.e("yunxun", " onViewInitFinished is " + arg0);
            }

            @Override
            public void onCoreInitFinished() {
            }
        };
        //x5内核初始化接口
        QbSdk.setDownloadWithoutWifi(true);
        QbSdk.initX5Environment(this, cb);
    }*/

    public static BaseComponent getBaseComponent() {
        if (null == baseComponent) {
            baseComponent = DaggerBaseComponent.builder().baseModule(new BaseModule(mContext)).okhttpModule(new OkhttpModule()).build();
        }
        return baseComponent;
    }

    /*private void setDatabase() {
        DaoMaster.DevOpenHelper mHelper  = new DaoMaster.DevOpenHelper(this, "notes-db", null);
        db = mHelper.getWritableDatabase();
        mDaoMaster = new DaoMaster(db);
        mDaoSession = mDaoMaster.newSession();
    }

    public DaoSession getDaoSession() {
        return mDaoSession;
    }*/

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);

//		        8.0语言适配
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
//            Resources resources = base.getResources();
//            String language = (String) SPUtils.get(base, SpManage.Language, "");
//            Locale newLocale = Locale.CHINESE;
//
//            if (language.equals("ch")) {
//                newLocale = Locale.CHINESE;
//            } else if (language.equals("en")) {
//                newLocale = Locale.ENGLISH;
//            } else if (language.equals("ar")) {
////                最后竟然没有Locale.ar常量，那就new一个
//                //阿拉伯
//                Locale arLocale = new Locale("ar");
//                newLocale = arLocale;
//            } else if (language.equals("la")) {
//                //拉丁文
//                Locale laocale = new Locale("la");
//                newLocale = laocale;
//            } else if (language.equals("sa")) {
//                //梵文
//                Locale saLocale = new Locale("sa");
//                newLocale = saLocale;
//            }
//
//            Locale locale = newLocale;
//
//            Configuration configuration = resources.getConfiguration();
//            configuration.setLocale(locale);
//            configuration.setLocales(new LocaleList(locale));
//            base = base.createConfigurationContext(configuration);
//        }

//        Beta.installTinker();
        registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
    }


    ActivityLifecycleCallbacks activityLifecycleCallbacks = new ActivityLifecycleCallbacks() {
        @Override
        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            Resources resources = activity.getResources();
            if (resources != null && resources.getConfiguration().fontScale != fontScale) {
                android.content.res.Configuration configuration = resources.getConfiguration();
                configuration.fontScale = fontScale;
                //设置大小
                resources.updateConfiguration(configuration, resources.getDisplayMetrics());
            }
            ActivityManager.getInstance().addActivity(activity);

            try {
                final View activityRoot = activity.getWindow().getDecorView();
                if (activityRoot == null) {
                    return;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityStarted(Activity activity) {
            if (count == 0)
                Log.e("block", "转换前台");
            count++;
        }

        @Override
        public void onActivityResumed(Activity activity) {

        }

        @Override
        public void onActivityPaused(Activity activity) {

        }

        @Override
        public void onActivityStopped(Activity activity) {
            count--;
            if (count == 0) {

            }
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            ActivityManager.getInstance().removeActivity(activity);
        }
    };

    //获取设置字体大小值
    public static float getFontScale() {
        float fontScale = 1.0f;
        if (instances != null) {
            fontScale = (float) SPUtils.get(getContext(), "fontScale", 1.0f);
        }
        return fontScale;
    }


   /* //调用该方法即可
    public static void setAppFontSize(float fontScale,Activity context) {
        if (instances != null) {
            List<Activity> activityList = instances.activityList;
            if (activityList != null) {
                for (Activity activity : activityList) {
                    //当前页面设置重启会闪黑屏
                    if (activity instanceof SetActivity) {
                        continue;
                    }
                    Resources resources = activity.getResources();
                    if (resources != null) {
                        android.content.res.Configuration configuration = resources.getConfiguration();
                        configuration.fontScale = fontScale;
                        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
                        activity.recreate();
                        if (fontScale != instances.fontScale) {
                            instances.fontScale = fontScale;
                            //保存设置后的字体大小
                            SharedPreferencesUtils.put(getContext(),"fontScale", fontScale);
                        }
                    }
                }
            }
        }
    }*/


    private void initHeightBugly() {
        /**
         * true表示app启动自动初始化升级模块;
         * false不会自动初始化;
         * 开发者如果担心sdk初始化影响app启动速度，可以设置为false，
         * 在后面某个时刻手动调用Beta.init(getApplicationContext(),false);
         */
        Beta.autoInit = true;

        /**
         * true表示初始化时自动检查升级;
         * false表示不会自动检查升级,需要手动调用Beta.checkUpgrade()方法;
         */
        Beta.autoCheckUpgrade = true;


//        Beta.canAutoDownloadPatch = false;

        /**
         * 设置升级检查周期为60s(默认检查周期为0s)，60s内SDK不重复向后台请求策略);
         */
        Beta.upgradeCheckPeriod = 60 * 1000;

        /**
         * 设置启动延时为1s（默认延时3s），APP启动1s后初始化SDK，避免影响APP启动速度;
         */
        Beta.initDelay = 1 * 1000;

        /**
         * 设置通知栏大图标，largeIconId为项目中的图片资源;
         */
//        Beta.largeIconId = R.drawable.hlq_img;

        /**
         * 设置状态栏小图标，smallIconId为项目中的图片资源Id;
         */
//        Beta.smallIconId = R.drawable.img;

        /**
         * 设置更新弹窗默认展示的banner，defaultBannerId为项目中的图片资源Id;
         * 当后台配置的banner拉取失败时显示此banner，默认不设置则展示“loading“;
         */
//        Beta.defaultBannerId = R.drawable.timg;

        /**
         * 设置sd卡的Download为更新资源保存目录;
         * 后续更新资源会保存在此目录，需要在manifest中添加WRITE_EXTERNAL_STORAGE权限;
         */
        Beta.storageDir = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);

        /**
         * 点击过确认的弹窗在APP下次启动自动检查更新时会再次显示;
         */
        Beta.showInterruptedStrategy = true;

        /**
         * 只允许在MainActivity上显示更新弹窗，其他activity上不显示弹窗;
         * 不设置会默认所有activity都可以显示弹窗;
         */
//        Beta.canShowUpgradeActs.add(HomeActivity.class);

        setStrictMode();
        // 设置是否开启热更新能力，默认为true
        Beta.enableHotfix = false;
        // 设置是否自动下载补丁
        Beta.canAutoDownloadPatch = true;
        // 设置是否提示用户重启
//        Beta.canNotifyUserRestart = true;
        // 设置是否自动合成补丁
        Beta.canAutoPatch = true;

        Beta.betaPatchListener = new BetaPatchListener() {
            @Override
            public void onPatchReceived(String patchFile) {
                Toast.makeText(BApplication.this, "补丁下载地址" + patchFile, Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onDownloadReceived(long savedLength, long totalLength) {
//                Toast.makeText(BApplication.this,
//                        String.format(Locale.getDefault(), "%s %d%%",
//                                Beta.strNotificationDownloading,
//                                (int) (totalLength == 0 ? 0 : savedLength * 100 / totalLength)),
//                        Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onDownloadSuccess(String msg) {
                Toast.makeText(BApplication.this, "补丁下载成功", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onDownloadFailure(String msg) {
                Toast.makeText(BApplication.this, "补丁下载失败", Toast.LENGTH_SHORT).show();

            }

            @Override
            public void onApplySuccess(String msg) {
//                Toast.makeText(BApplication.this, "补丁应用成功", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onApplyFailure(String msg) {
//                Toast.makeText(BApplication.this, "补丁应用失败", Toast.LENGTH_SHORT).show();
                Log.e("yunxun", "补丁应用失败：" + msg);
            }

            @Override
            public void onPatchRollback() {

            }
        };

        /***** 统一初始化Bugly产品，包含Beta *****/
        Bugly.init(this, "cc47386aa5", true);
    }

   /* private void initUpush() {
        PushAgent mPushAgent = PushAgent.getInstance(this);
        handler = new Handler(getMainLooper());

        //sdk开启通知声音
        mPushAgent.setNotificationPlaySound(MsgConstant.NOTIFICATION_PLAY_SDK_ENABLE);
        // sdk关闭通知声音
        // mPushAgent.setNotificationPlaySound(MsgConstant.NOTIFICATION_PLAY_SDK_DISABLE);
        // 通知声音由服务端控制
        // mPushAgent.setNotificationPlaySound(MsgConstant.NOTIFICATION_PLAY_SERVER);

        // mPushAgent.setNotificationPlayLights(MsgConstant.NOTIFICATION_PLAY_SDK_DISABLE);
        // mPushAgent.setNotificationPlayVibrate(MsgConstant.NOTIFICATION_PLAY_SDK_DISABLE);

        UmengMessageHandler messageHandler = new UmengMessageHandler() {

//            *
//             * 通知的回调方法（通知送达时会回调）

            @Override
            public void dealWithNotificationMessage(Context context, UMessage msg) {
                //调用super，会展示通知，不调用super，则不展示通知。
                super.dealWithNotificationMessage(context, msg);
            }

//            *
//             * 自定义消息的回调方法

            @Override
            public void dealWithCustomMessage(final Context context, final UMessage msg) {

                handler.post(new Runnable() {

                    @Override
                    public void run() {
                        // TODO Auto-generated method stub
                        // 对自定义消息的处理方式，点击或者忽略
                        boolean isClickOrDismissed = true;
                        if (isClickOrDismissed) {
                            //自定义消息的点击统计
                            UTrack.getInstance(getApplicationContext()).trackMsgClick(msg);
                        } else {
                            //自定义消息的忽略统计
                            UTrack.getInstance(getApplicationContext()).trackMsgDismissed(msg);
                        }
                        Toast.makeText(context, msg.custom, Toast.LENGTH_LONG).show();
                    }
                });
            }

//            *
//             * 自定义通知栏样式的回调方法

            @Override
            public Notification getNotification(Context context, UMessage msg) {
                switch (msg.builder_id) {
                    case 1:
                        Notification.Builder builder = new Notification.Builder(context);
                       *//* RemoteViews myNotificationView = new RemoteViews(context.getPackageName(),
                                R.layout.notification_view);
                        myNotificationView.setTextViewText(R.id.notification_title, msg.title);
                        myNotificationView.setTextViewText(R.id.notification_text, msg.text);
                        myNotificationView.setImageViewBitmap(R.id.notification_large_icon, getLargeIcon(context, msg));
                        myNotificationView.setImageViewResource(R.id.notification_small_icon,
                                getSmallIconId(context, msg));
                        builder.setContent(myNotificationView)
                                .setSmallIcon(getSmallIconId(context, msg))
                                .setTicker(msg.ticker)
                                .setAutoCancel(true);*//*

                        return builder.getNotification();
                    default:
                        //默认为0，若填写的builder_id并不存在，也使用默认。
                        return super.getNotification(context, msg);
                }
            }
        };
        mPushAgent.setMessageHandler(messageHandler);

//        *
//         * 自定义行为的回调处理，参考文档：高级功能-通知的展示及提醒-自定义通知打开动作
//         * UmengNotificationClickHandler是在BroadcastReceiver中被调用，故
//         * 如果需启动Activity，需添加Intent.FLAG_ACTIVITY_NEW_TASK
//         *
        UmengNotificationClickHandler notificationClickHandler = new UmengNotificationClickHandler() {

            @Override
            public void launchApp(Context context, UMessage msg) {
                super.launchApp(context, msg);
            }

            @Override
            public void openUrl(Context context, UMessage msg) {
                super.openUrl(context, msg);
            }

            @Override
            public void openActivity(Context context, UMessage msg) {
                super.openActivity(context, msg);
            }

            @Override
            public void dealWithCustomAction(Context context, UMessage msg) {
                Toast.makeText(context, msg.custom, Toast.LENGTH_LONG).show();
            }
        };
        //使用自定义的NotificationHandler
        mPushAgent.setNotificationClickHandler(notificationClickHandler);
        //注册推送服务 每次调用register都会回调该接口
        mPushAgent.register(new IUmengRegisterCallback() {
            @Override
            public void onSuccess(String deviceToken) {
                Log.e(TAG, "device token: " + deviceToken);
//                sendBroadcast(new Intent(UPDATE_STATUS_ACTION));
            }

            @Override
            public void onFailure(String s, String s1) {
                Log.i(TAG, "register failed: " + s + " " + s1);
//                sendBroadcast(new Intent(UPDATE_STATUS_ACTION));
            }
        });

        //使用完全自定义处理
        //mPushAgent.setPushIntentServiceClass(UmengNotificationService.class);

        //小米通道
        //MiPushRegistar.register(this, XIAOMI_ID, XIAOMI_KEY);
        //华为通道
        //HuaWeiRegister.register(this);
        //魅族通道
        //MeizuRegister.register(this, MEIZU_APPID, MEIZU_APPKEY);
    }


    public static String[] getTestDeviceInfo(Context context){
        String[] deviceInfo = new String[2];
        try {
            if(context != null){
                deviceInfo[0] = DeviceConfig.getDeviceIdForGeneral(context);
                deviceInfo[1] = DeviceConfig.getMac(context);
            }
        } catch (Exception e){
        }
        return deviceInfo;
    }*/

    @TargetApi(9)
    protected void setStrictMode() {
        StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder().permitAll().build());
        StrictMode.setVmPolicy(new StrictMode.VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    /**
     * 初始化方法
     *
     * @param application
     * @must 调用init方法且只能调用一次，如果extends BaseApplication会自动调用
     */
    public static void init(Application application) {
        instance = application;
        if (instance == null) {
            com.bxzk.afxj.util.Log.e(TAG, "\n\n\n\n\n !!!!!! 调用BaseApplication中的init方法，instance不能为null !!!" +
                    "\n <<<<<< init  instance == null ！！！ >>>>>>>> \n\n\n\n");
        }
        DataKeeper.init(instance);
        SettingUtil.init(instance);
    }

    private void initSophix() {
       /* String appVersion = "0.0.0";
        try {
            appVersion = this.getPackageManager()
                    .getPackageInfo(this.getPackageName(), 0)
                    .versionName;
        } catch (Exception e) {
        }
        final SophixManager instance = SophixManager.getInstance();
        instance.setContext(this)
                .setAppVersion(appVersion)
                .setSecretMetaData(null, null, null)
                .setEnableDebug(true)
                .setEnableFullLog()
                .setPatchLoadStatusStub(new PatchLoadStatusListener() {
                    @Override
                    public void onLoad(final int mode, final int code, final String info, final int handlePatchVersion) {
                        if (code == PatchStatus.CODE_LOAD_SUCCESS) {
                            com.yunsx.test.util.Log.i(TAG, "sophix load patch success!");
                        } else if (code == PatchStatus.CODE_LOAD_RELAUNCH) {
                            // 如果需要在后台重启，建议此处用SharePreference保存状态。
                            com.yunsx.test.util.Log.i(TAG, "sophix preload patch success. restart app to make effect.");
                        }
                        com.yunsx.test.util.Log.e("热修复状态码"+ code);
                    }
                }).initialize();*/
    }




}
