package com.bxzk.afxj.database.table;

import com.bxzk.afxj.database.CommonDaoUtils;
import com.bxzk.afxj.database.DaoManager;
import com.bxzk.afxj.database.bean.User;
import com.bxzk.afxj.UserDao;

/**
 * 初始化、存放及获取DaoUtils
 */
public class DaoUtilsStore {
    private volatile static DaoUtilsStore instance = new DaoUtilsStore();
    private CommonDaoUtils<User> mUserDaoUtils;

    public static DaoUtilsStore getInstance() {
        return instance;
    }

    private DaoUtilsStore() {
        DaoManager mManager = DaoManager.getInstance();
        UserDao _UserDao = mManager.getDaoSession().getUserDao();
    }

    public CommonDaoUtils<User> getUserDaoUtils() {
        return mUserDaoUtils;
    }
}
