package com.bxzk.afxj.other;

import android.graphics.Rect;
import android.view.View;

import androidx.recyclerview.widget.RecyclerView;

import com.bxzk.afxj.util.DensityUtils;
import com.bxzk.afxj.util.ScreenUtils;


/*
* LinearLayoutManager设置Item间距的的一个辅助类
* */
public class SpacesItemDecoration extends RecyclerView.ItemDecoration {

    public SpacesItemDecoration() {
    }

    private int space;

    public SpacesItemDecoration(int space) {
        this.space = space;
    }

    @Override
    public void getItemOffsets(Rect outRect, View view,
                               RecyclerView parent, RecyclerView.State state) {

        int space = (ScreenUtils.getWidth() - DensityUtils.dip2px(40)- 4 * DensityUtils.dip2px( 76))/6;
        if(parent.getChildAdapterPosition(view) %4 ==  0) {
            outRect.left = DensityUtils.dip2px( 20);
            outRect.right = space;
        }else if(parent.getChildAdapterPosition(view) %4 ==  3) {
            outRect.right = DensityUtils.dip2px(20);
            outRect.left = space;
        }else {
            outRect.right =space;
            outRect.left =space;
        }
        outRect.bottom = DensityUtils.dip2px( 10);
      /*  outRect.left = 20;
        outRect.right = 20;
        outRect.bottom = 20;
*/


        // Add top margin only for the first item to avoid double space between items

    }
}
