package com.bxzk.afxj.retrofit;


import com.bxzk.afxj.application.BApplication;
import com.bxzk.afxj.util.Log;
import com.bxzk.afxj.util.MD5Util;
import com.bxzk.afxj.util.SPUtils;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RxDownloadInterceptor implements  Interceptor {
    private RxDownloadListener downloadListener;

    public RxDownloadInterceptor(RxDownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {

        Request original = chain.request();
        Request.Builder builder = original.newBuilder();
        String token = (String) SPUtils.get(BApplication.getInstances().getApplicationContext(), "token", "");
        Log.e("Come to the Token:"+token);
        Request requestBuilder = builder
                .addHeader("token", token)
//                .addHeader("apiCode", "kangwen")//账号
//                .addHeader("apiKey", "123456")//密码
//                .addHeader("timeSpan", "20181105")//当前时间戳
//                .addHeader("sign", getsign())
                .build();//签名
        Response response = chain.proceed(requestBuilder);
        return response.newBuilder().body(new RxResponseBody(response.body(), downloadListener)).build();

    }
  public String getsign(){
        StringBuffer stringBuffer=new StringBuffer();
        stringBuffer.append("kangwen");
        stringBuffer.append("123456");
        stringBuffer.append("20181105");
        return MD5Util.MD5(stringBuffer.toString());
  }
}
