package com.bxzk.afxj.retrofit;

import android.content.Context;

import com.bxzk.afxj.Entity.BaseListBean;
import com.bxzk.afxj.application.BApplication;
import com.bxzk.afxj.util.Log;
import com.bxzk.afxj.util.ToastUtils;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import retrofit2.HttpException;

public abstract class SimpleSubscriber<T> implements Observer<T> {
    Context context = BApplication.getContext();

    @Override
    public void onNext(T t) {

        showDialog();
        if (t != null) {//这里最好判断一下是否为null.
            if (t.equals("1")) {
                call1();
            } else if (t instanceof BaseListBean) {
                BaseListBean bean = (BaseListBean) t;
                callList(bean);
            } else {
                call(t);
            }
        } else {
//            ToastUtil.showToast("连接失败");
        }

    }

    public void callList(BaseListBean t) {

    }


    public void call1() {

    }

    public void showDialog() {

    }

    public void hideDialog() {

    }

    @Override
    public void onError(Throwable e) {//这里通常就处理异常
        hideDialog();
        Log.e("异常：" + e.getMessage());
        if (e instanceof ApiException) {
            ApiException exception = (ApiException) e;
            if (exception.getResultCode() == 401) {
                backToLogin();
            } else if (exception.getResultCode() == 200) {
                onDataEmpty();
            } else if (exception.getResultCode() == 250) {
                onDataEmpty();
            } else if (exception.getResultCode() == 500) {
                onDataEmpty();
                ToastUtils.showToast(e.getMessage());
            } else {

            }

        } else if (e instanceof UnknownHostException) {
            ToastUtils.showToast(context, "请打开网络");
//            ToastUtil.showToast();
        } else if (e instanceof SocketTimeoutException) {
//            ToastUtils.showToast(context,"请求超时");
        } else if (e instanceof ConnectException) {
            ToastUtils.showToast(context, "网络异常，请稍后重试");
        } else if (e instanceof HttpException) {
            ToastUtils.showToast(context, "服务器500");
//            ToastUtils.showToast(context,"请求超时");
        } else {
//            ToastUtils.showToast(context,"请求失败");
        }
        e.printStackTrace();
    }

    //data为null的时候 调用成功
    public void onDataEmpty() {

    }

    private void backToLogin() {
        /*ActivityManager.getInstance().removeAllActivity();
        SPUtils.put(BApplication.getContext(), "islogin", false);
        Intent intent = new Intent(context, LoginActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);*/

    }

    @Override
    public void onComplete() {
    }

    @Override
    public void onSubscribe(Disposable d) {

    }

    /**
     * 因为具体的处理这里无法得知,所以抽象.
     */
    public abstract void call(T t);
}
