package com.bxzk.afxj.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;
import android.widget.TextView;


import androidx.core.content.FileProvider;

import com.bxzk.afxj.R;
import com.bxzk.afxj.retrofit.RxDownloadListener;

import java.io.File;

public class AppUpdateUtils {

    public static String getVersionCode(Context context) {
        try {
            String versionName = context.getPackageManager().
                    getPackageInfo(context.getPackageName(), 0).versionName;
            Long number = CommonUtil.getNumber(versionName);
            return versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return "1.0.0";
    }

    public static void setAlpha(Context context, float _f) {
        WindowManager.LayoutParams params = ((Activity) context).getWindow().getAttributes();
        params.alpha = _f;
        ((Activity) context).getWindow().setAttributes(params);
    }

    public static void checkVersion(final Context context, final boolean isTip, RxDownloadListener listener) {
//获取软件版本号，对应AndroidManifest.xml下android:versionCode
       /* final String mVersionCode = AppUpdateUtils.getVersionCode(context);
        Long thisVersion = CommonUtil.getNumber(mVersionCode);
        Long newVersion = 11l;
        if (thisVersion < newVersion) {
            setAlpha(context, 0.5f);
            final View contentView = View.inflate(context, R.layout.window_update, null);
            final PopupWindow popupWindow = new PopupWindow(contentView, ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT, true);
            TextView tTitle = contentView.findViewById(R.id.tv_title);
//            tTitle.setText(R.string.new_version);
            TextView tContent = contentView.findViewById(R.id.tContent);
//            tContent.setText(response.body().getDescription());
            TextView bt_cancel = contentView.findViewById(R.id.bt_cancel);
            TextView bt_confirm = contentView.findViewById(R.id.bt_confirm);
//            final String path = response.body().getDownloadUrl();
            bt_cancel.setOnClickListener(v -> {
                popupWindow.dismiss();
            });
            bt_confirm.setOnClickListener(v -> {
                popupWindow.dismiss();
                downFile(context, listener);
            });
            popupWindow.setTouchable(true);
            popupWindow.setOutsideTouchable(true);
            popupWindow.setFocusable(true);
            popupWindow.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener() {
                @Override
                public void onDismiss() {
                    setAlpha(context, 1.0f);
                }
            });
            if (context != null && !((Activity) context).isFinishing()) {
                popupWindow.showAtLocation(contentView, Gravity.CENTER, 0, 0);
            }
        } else {
            if (isTip) {
                ToastUtils.showToast(context, R.string.already_new_version);

            }
        }*/
        ;

    }

    private static void downFile(Context context, RxDownloadListener listener) {
        if (CommonUtil.isNetWorkConnected(context)) {
//            DownloadUtils dUtils = new DownloadUtils(listener);
//            File download = dUtils.download(Environment.getExternalStorageDirectory().getPath() + "/DYF/1.png", "http://www.wanandroid.com/blogimgs/ab17e8f9-6b79-450b-8079-0f2287eb6f0f.png", listener);
        }
    }

    public static void installAPK(Context ctx, File file) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) { //Android 7.0及以上
            // 参数2 清单文件中provider节点里面的authorities ; 参数3  共享的文件,即apk包的file类
            Uri apkUri = FileProvider.getUriForFile(ctx, "com.bxzk.afxj.fileProvider", file);
            //对目标应用临时授权该Uri所代表的文件
            intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
            intent.setDataAndType(apkUri, "application/vnd.android.package-archive");
        } else {
            intent.setDataAndType(Uri.fromFile(file), "application/vnd.android.package-archive");
        }
        ctx.startActivity(intent);
    }



    public static String getApkPath(Activity activity) {

        String directoryPath="";
        if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState()) ) {//判断外部存储是否可用
            directoryPath =activity.getExternalFilesDir("apk").getAbsolutePath();
        }else{//没外部存储就使用内部存储
            directoryPath=activity.getFilesDir()+File.separator+"apk";
        }
        File file = new File(directoryPath);
        Log.e("yunxun",directoryPath);
        if(!file.exists()){//判断文件目录是否存在
            file.mkdirs();
        }
        return directoryPath;
    }

}
