package com.bxzk.afxj.util;

import android.app.ActivityManager;
import android.content.Context;

import java.util.ArrayList;
import java.util.List;

public class ComplexUtil {



    //
    public static boolean compare(int hourStart, int minuteStart, int hourEnd, int minuteEnd) {
        if (hourStart < hourEnd) {
            return true;


        } else if (hourStart == hourEnd && minuteStart < minuteEnd) {
            return true;

        }
        return false;
    }

    public static <T> List<List<T>> splitList(List<T> list, int groupSize) {
        int length = list.size();
        // 计算可以分成多少组
        int num = (length + groupSize - 1) / groupSize; // TODO
        List<List<T>> newList = new ArrayList<>(num);
        for (int i = 0; i < num; i++) {
            // 开始位置
            int fromIndex = i * groupSize;
            // 结束位置
            int toIndex = (i + 1) * groupSize < length ? (i + 1) * groupSize : length;
            newList.add(list.subList(fromIndex, toIndex));
        }
        return newList;
    }

    public static boolean isRunning(Context c, String serviceName) {
        ActivityManager myAM = (ActivityManager) c.getSystemService(Context.ACTIVITY_SERVICE);

        ArrayList<ActivityManager.RunningServiceInfo> runningServices = (ArrayList<ActivityManager.RunningServiceInfo>) myAM.getRunningServices(40);
        //获取最多40个当前正在运行的服务，放进ArrList里,以现在手机的处理能力，要是超过40个服务，估计已经卡死，所以不用考虑超过40个该怎么办
        for (int i = 0; i < runningServices.size(); i++)//循环枚举对比
        {
            if (runningServices.get(i).service.getClass().getSimpleName().equals(serviceName)) {
                return true;
            }
        }
        return false;
    }
}
