package com.bxzk.afxj.util;

import android.os.CountDownTimer;
import android.widget.TextView;

import com.bxzk.afxj.R;

import java.lang.ref.WeakReference;

public class CountDownTimerUtils extends CountDownTimer {

    WeakReference<TextView> mTextView; //显示倒计时的文字  用弱引用 防止内存泄漏

    public CountDownTimerUtils(TextView textView, long millisInFuture, long countDownInterval) {
        super(millisInFuture, countDownInterval);
        this.mTextView = new WeakReference(textView);
    }

    public void startCount() {
        if (this != null) {
            this.start();
        }

    }

    @Override
    public void onTick(long l) {
        //用弱引用 先判空 避免崩溃
        if (mTextView.get() == null) {
            cancle();
            return;
        }


        long day = l / (1000 * 24 * 60 * 60); //单位天
        long hour = (l - day * (1000 * 24 * 60 * 60)) / (1000 * 60 * 60); //单位时
        long minute = (l - day * (1000 * 24 * 60 * 60) - hour * (1000 * 60 * 60)) / (1000 * 60); //单位分
        long second = (l - day * (1000 * 24 * 60 * 60) - hour * (1000 * 60 * 60) - minute * (1000 * 60)) / 1000;//单位秒
        mTextView.get().setText(CommonUtil.getResourceStr(R.string.time_counter, hour, minute, second));
//        mTextView.setBackgroundResource(R.drawable.validate_code_press_bg); //设置按钮为灰色，这时是不能点击的
//        SpannableString spannableString = new SpannableString(mTextView.getText().toString()); //获取按钮上的文字
//        @SuppressLint("ResourceAsColor") ForegroundColorSpan span = new ForegroundColorSpan(R.color.text_gray);
//        /**
//         * public void setSpan(Object what, int start, int end, int flags) {
//         * 主要是start跟end，start是起始位置,无论中英文，都算一个。
//         * 从0开始计算起。end是结束位置，所以处理的文字，包含开始位置，但不包含结束位置。
//         */
//        spannableString.setSpan(span, 0, 2, Spannable.SPAN_INCLUSIVE_EXCLUSIVE);//将倒计时的时间设置为红色
//        mTextView.get().setText(spannableString);
        mTextView.get().setText(mTextView.get().getText().toString());
    }

    @Override
    public void onFinish() {
        //用软引用 先判空 避免崩溃
        if (mTextView.get() == null) {
            cancle();
            return;
        }
//      mTextView.setBackgroundResource(R.drawable.validate_code_normal_bg); //还原背景色
    }

    public void cancle() {
        if (this != null) {
            this.cancel();
        }
    }


}
