package com.bxzk.afxj.util;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;

import androidx.core.app.ActivityCompat;

import com.bxzk.afxj.application.BApplication;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class DeviceUtils {


    public static String getSN(Context context) {
          String SN = "";
        if(context == null){
            return null;
        }
        if (!TextUtils.isEmpty(SN)) {
            return SN;
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
            return SN;
        }
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                SN = Build.getSerial();
            } else {
                SN = Build.SERIAL;
            }
        } catch (Exception e) {
        }
        return SN;
    }
    public static String getSystemModel(Context context) {
          String SN = "";
        if(context == null){
            return null;
        }
        if (!TextUtils.isEmpty(SN)) {
            return SN;
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
            return SN;
        }
        try {
            SN = Build.MODEL;
        } catch (Exception e) {
        }
        return SN;
    }

    public static String getMacAddress() {
        String macAddress = null ;
        String str = "" ;
        try {
            //linux下查询网卡mac地址的命令
            Process pp = Runtime.getRuntime().exec( "cat /sys/class/net/wlan0/address" );
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);

            for (; null != str;) {
                str = input.readLine();
                if (str != null ) {
                    macAddress = str.trim();// 去空格
                    break ;
                }
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        return macAddress;
    }

    public static String getMacAddressOther() {

        String macAddress = null ;

        WifiManager wifiManager =
                (WifiManager) BApplication.getContext().getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        WifiInfo info = ( null == wifiManager ? null : wifiManager.getConnectionInfo());

        macAddress = info.getMacAddress();
        return macAddress;
    }
    public static String getIpAddress(Context context) {

        String ip = "";
        ConnectivityManager conMann = (ConnectivityManager)
                context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo mobileNetworkInfo = conMann.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);
        NetworkInfo wifiNetworkInfo = conMann.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

        if (mobileNetworkInfo.isConnected()) {
//            ip = getLocalIpAddress();
//            System.out.println("本地ip-----"+ip);
        }else if(wifiNetworkInfo.isConnected())
        {
            WifiManager wifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            int ipAddress = wifiInfo.getIpAddress();
            ip = intToIp(ipAddress);
//            System.out.println("wifi_ip地址为------"+ip);
        }

    return ip;

    }


    public static String intToIp(int ipInt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipInt & 0xFF).append(".");
        sb.append((ipInt >> 8) & 0xFF).append(".");
        sb.append((ipInt >> 16) & 0xFF).append(".");
        sb.append((ipInt >> 24) & 0xFF);
        return sb.toString();
    }
}
