
package com.bxzk.afxj.util;

/**
 * Created by stone on 2018/7/24.
 * --------- 日期 ------- 维护人 ------------ 变更内容 --------
 * 2018/7/24        stone             新增Person类
 * 2018/7/24        stone             增加sex属性
 */


import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.DrawableCrossFadeFactory;
import com.bumptech.glide.request.transition.Transition;
import com.bxzk.afxj.application.BApplication;
import com.bxzk.afxj.other.GlideBlurformation;

import java.io.File;

import jp.wasabeef.glide.transformations.BlurTransformation;


public class GlideUtils {
    /*
    *
    *  Glide.with(this).load("url")
        .placeholder(R.drawable.ic_launcher)//占位图 未加载时显示
        .error(R.drawable.icon)//加载失败时显示
        .crossFade() //设置显示动画
        .override(200, 240)//裁剪 fitCenter()和centerCrop() 显示模式
        .into(image);
    * */

    private static GlideUtils sInstance;
    private static Context mContext;

    private GlideUtils() {
    }

    public static GlideUtils getInstance() {
        if (sInstance == null) {
            sInstance = new GlideUtils();
        }
        mContext = BApplication.getContext();

        return sInstance;
    }

    /**
     * 从网络加载图片
     *
     * @param view
     * @param url
     */
    public void display(ImageView view, String url) {
        Glide.with(mContext)
                .load(url)
                .into(view);
    }

    /**
     * 从网络加载图片 4 圆角
     *
     * @param view
     * @param url
     */
    public void displayround(ImageView view, String url, int round) {
        //设置图片圆角角度
        RoundedCorners roundedCorners = new RoundedCorners(round);
//通过RequestOptions扩展功能,override:采样率,因为ImageView就这么大,可以压缩图片,降低内存消耗
        RequestOptions options = RequestOptions.bitmapTransform(roundedCorners).override(300, 300);

        Glide.with(mContext)

                .load(url)
                .apply(options)
                .into(view);
    }
    public void displayCicle(ImageView view, String url) {
        //设置图片圆角角度

        Glide.with(mContext)

                .load(url)
                .apply(RequestOptions.bitmapTransform(new CircleCrop()))
                .into(view);
    }



//    毛玻璃效果
    public void displayBlur(ImageView view, String url) {
//        view.setBackgroundColor(Color.parseColor("#171717"));

        Glide.with(mContext)
                .load(url)

                .apply(RequestOptions.bitmapTransform(new GlideBlurformation(mContext)))
                .into(view);
    }
    public void displayBlur1(ImageView view, String url) {
//        view.setBackgroundColor(Color.parseColor("#171717"));
        Glide.with(mContext).load(url)

                .apply(RequestOptions.bitmapTransform(new BlurTransformation(mContext, 25)))

                .into(view);

    }

    /**
     * 获取网络图片，设置默认图片与请求失败图片为同一张图片
     *
     * @param view
     * @param url
     * @param defualtImg
     */
    public void display(ImageView view, String url, @DrawableRes int defualtImg) {
        RequestOptions options = new RequestOptions()
                .placeholder(defualtImg)
                .error(defualtImg)

                .diskCacheStrategy(DiskCacheStrategy.NONE);
        DrawableCrossFadeFactory drawableCrossFadeFactory = new DrawableCrossFadeFactory.Builder(300).setCrossFadeEnabled(true).build();
        Glide.with(mContext)
                .load(url)
                .apply(options)
                .transition(DrawableTransitionOptions.with(drawableCrossFadeFactory))
//                .placeholder(defualtImg)
                .into(view);
    }


    /**
     * 圆形、默认图片、失败图片
     *
     * @param view
     * @param url
     * @param defualtImg
     */
    public void playPlayHead(ImageView view, String url, @DrawableRes int defualtImg) {
        RequestOptions options = new RequestOptions().placeholder(defualtImg)
                .error(defualtImg)
                .transform(new CenterCrop())
                .diskCacheStrategy(DiskCacheStrategy.NONE);
        Glide.with(mContext).load(url).apply(options).into(view);
    }


    public void display(ImageView view, String url, Drawable defualtImg) {
        RequestOptions options = new RequestOptions()
                .placeholder(defualtImg)
                .error(defualtImg)
                .diskCacheStrategy(DiskCacheStrategy.NONE);
        Glide.with(mContext)
                .load(url)
                .apply(options)
                .into(view);
    }

    public void display(ImageView view, String url, @DrawableRes int defualtImg, @DrawableRes int errorImg) {
        RequestOptions options = new RequestOptions()
                .placeholder(defualtImg)
                .error(defualtImg)
                .diskCacheStrategy(DiskCacheStrategy.NONE);
        Glide.with(mContext)

                .load(url)
                .apply(options)
                .into(view);
    }

    public void display(ImageView view, File file) {
        Glide.with(mContext)
                .load(Uri.fromFile(file))
                .into(view);
    }

    public void display(ImageView view, File file, @DrawableRes int defualtImg) {
        RequestOptions options = new RequestOptions()
                .placeholder(defualtImg)
                .error(defualtImg)
                .diskCacheStrategy(DiskCacheStrategy.NONE);
        Glide.with(mContext)
                .load(Uri.fromFile(file))
                .apply(options)
//                .placeholder(defualtImg)
                .into(view);
    }

    public void display(ImageView view, @DrawableRes int resId) {
        Glide.with(mContext)
                .load(resId)
                .into(view);

    }


    //网络加载成功更改tv drawable图片：
    public void setTextDraw(TextView textView, String imgUrl) {
        SimpleTarget<Drawable> simpleTarget = new SimpleTarget<Drawable>() {
            @Override
            public void onResourceReady(Drawable resource, Transition<? super Drawable> transition) {
                resource.setBounds(0, 0, resource.getMinimumWidth(), resource.getMinimumHeight());
                textView.setCompoundDrawables(resource, null, null, null);
            }
        };

        Glide.with(mContext)
                .load("http://guolin.tech/book.png")
                .into(simpleTarget);


    }

    public void setGifDraw(int Resrc,ImageView imageView) {
        Glide.with(mContext).load(Resrc).listener(new RequestListener() {
            @Override
            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target target, boolean isFirstResource) {
                return false;
            }

            @Override
            public boolean onResourceReady(Object resource, Object model, Target target, DataSource dataSource, boolean isFirstResource) {
                if (resource instanceof GifDrawable) {
                    //加载一次
                    ((GifDrawable)resource).setLoopCount(10);
                }
                return false;
            }


        }).into(imageView);
    }

    public static Bitmap createCircleBitmap(Bitmap resource)
    {
        //获取图片的宽度
        int width = resource.getWidth();
        Paint paint = new Paint();
        //设置抗锯齿
        paint.setAntiAlias(true);

        //创建一个与原bitmap一样宽度的正方形bitmap
        Bitmap circleBitmap = Bitmap.createBitmap(width, width, Bitmap.Config.ARGB_8888);
        //以该bitmap为低创建一块画布
        Canvas canvas = new Canvas(circleBitmap);
        //以（width/2, width/2）为圆心，width/2为半径画一个圆
        canvas.drawCircle(width/2, width/2, width/2, paint);

        //设置画笔为取交集模式
        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        //裁剪图片
        canvas.drawBitmap(resource, 0, 0, paint);

        return circleBitmap;
    }
}
