package com.bxzk.afxj.util;

import android.content.res.Configuration;
import android.os.Build;

import com.bxzk.afxj.application.BApplication;

import java.util.Locale;

/**
 * Created by Stone on 2018/10/25.
 */
public class LanguageUtils {
    public static void switchLanguage(int position) {
        Configuration configuration = BApplication.getInstances().getApplicationContext().getResources().getConfiguration();
        switch (position) {
            case 0:
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    configuration.setLocale(Locale.CHINESE);
                } else {
                    configuration.locale = Locale.CHINESE;
                }
                break;
            case 1:
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    configuration.setLocale(Locale.ENGLISH);
                } else {
                    configuration.locale = Locale.ENGLISH;
                }
                break;
            case 2:

                //梵文
                Locale saLocale = new Locale("sa");
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    configuration.setLocale(saLocale);
                } else {
                    configuration.locale = saLocale;
                }


                break;
            case 3:

                //阿拉伯文
                Locale arLocale = new Locale("ar");

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    configuration.setLocale(arLocale);
                } else {
                    configuration.locale = arLocale;
                }


                break;
            case 4:
                //拉丁文
                Locale laocale = new Locale("la");

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    configuration.setLocale(laocale);
                } else {
                    configuration.locale = laocale;
                }
                break;
        }
        BApplication.getInstances().getApplicationContext().getResources().updateConfiguration(configuration, BApplication.getInstances().getApplicationContext().getResources().getDisplayMetrics());
    }








//    public static int getLanguagePosition(int position) {
//        switch (position) {
//            case 0:
//                return 1;
//            case 1:
//                return 2;
//            case 2:
//                return 0;
//            case 3:
//                return 3;
//            case 4:
//                return 4;
//        }
//        return position;
//    }
//
//    public static int getLanguagePosition2(int position) {
//        switch (position) {
//            case 0:
//                return 2;
//            case 1:
//                return 0;
//            case 2:
//                return 1;
//            case 3:
//                return 3;
//            case 4:
//                return 4;
//        }
//        return position;
//    }

}
