package com.bxzk.afxj.util;

import android.app.Dialog;
import android.content.DialogInterface;
import android.view.animation.Animation;


import androidx.appcompat.app.AlertDialog;

import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;


/**
 * Created by shuj on 2019/1/2
 */
public class PrayerUtils implements Dialog.OnDismissListener{
    private AlertDialog mDialog;
    private Animation mAnimation;
    private Disposable mDisposable;


    public void dismissDialog() {
        if (mDialog != null && mDialog.isShowing()) {
            mDialog.dismiss();
        }
        if (mDisposable!=null){
            mDisposable.dispose();
        }
    }
    /**
     * 倒计时
     */
    public void verify() {
        final int count = 5;//倒计时10秒
        Observable.interval(0, 1, TimeUnit.SECONDS)
                .take(count + 1)
                .map(aLong -> count - aLong)
                .observeOn(AndroidSchedulers.mainThread())//ui线程中进行控件更新
                .doOnSubscribe(new Consumer<Disposable>() {
                    @Override
                    public void accept(Disposable disposable) throws Exception {
                    }
                }).subscribe(new Observer<Long>() {
            @Override
            public void onSubscribe(Disposable d) {
                mDisposable = d;
            }

            @Override
            public void onNext(Long num) {
            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onComplete() {
                dismissDialog();
            }
        });
    }
    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        dismissDialog();
    }
}
