/*Copyright ©2015 TommyLemon(https://github.com/TommyLemon)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.*/

package com.bxzk.afxj.util;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;


import androidx.annotation.StringRes;

import com.bxzk.afxj.application.BApplication;

import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**通用字符串(String)相关类,为null时返回""
 * @author Lemon
 * @use StringUtil.xxxMethod(...);
 */
public class StringUtil {
	private static final String TAG = "StringUtil";


	private static String currentString = "";
	/**获取刚传入处理后的string
	 * @must 上个影响currentString的方法 和 这个方法都应该在同一线程中，否则返回值可能不对
	 * @return
	 */
	public static String getCurrentString() {
		return currentString == null ? "" : currentString;
	}


	//获取string,为null时返回"" <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	/**获取string,为null则返回""
	 * @param tv
	 * @return
	 */
	public static String get(TextView tv) {
		if (tv == null || tv.getText() == null) {
			return "";
		}
		return tv.getText().toString();
	}
	/**获取string,为null则返回""
	 * @param tv
	 * @return
	 */
	public static String getstring(String tv) {
		if (tv == null || TextUtils.isEmpty(tv)||tv.equals("null")) {
			return "";
		}
		return tv;
	}


	/**获取string,为null则返回""
	 * @param object
	 * @return
	 */
	public static String get(Object object) {
		return object == null ? "" : object.toString();
	}
	/**获取string,为null则返回""
	 * @param cs
	 * @return
	 */
	public static String get(CharSequence cs) {
		return cs == null ? "" : cs.toString();
	}
	/**获取string,为null则返回""
	 * @param s
	 * @return
	 */
	public static String get(String s) {
		return s == null ? "" : s;
	}


	/**deprecated 用get代替，这个保留到17.0
	 */
	public static String getString(TextView tv) {
		return get(tv);
	}
	/**deprecated 用get代替，这个保留到17.0
	 */
	public static String getString(Object object) {
		return get(object);
	}
	/**deprecated 用get代替，这个保留到17.0
	 */
	public static String getString(CharSequence cs) {
		return get(cs);
	}
	/**deprecated 用get代替，这个保留到17.0
	 */
	public static String getString(String s) {
		return get(s);
	}

	//获取string,为null时返回"" >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>





	//获取去掉前后空格后的string<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	/**获取去掉前后空格后的string,为null则返回""
	 * @param tv
	 * @return
	 */
	public static String trim(TextView tv) {
		return trim(get(tv));
	}
	/**获取去掉前后空格后的string,为null则返回""
	 * @param object
	 * @return
	 */
	public static String trim(Object object) {
		return trim(get(object));
	}
	/**获取去掉前后空格后的string,为null则返回""
	 * @param cs
	 * @return
	 */
	public static String trim(CharSequence cs) {
		return trim(get(cs));
	}
	/**获取去掉前后空格后的string,为null则返回""
	 * @param s
	 * @return
	 */
	public static String trim(String s) {
		return s == null ? "" : s.trim();
	}


	/**deprecated 用trim代替，这个保留到17.0
	 */
	public static String getTrimedString(TextView tv) {
		return trim(tv);
	}
	/**deprecated 用trim代替，这个保留到17.0
	 */
	public static String getTrimedString(Object object) {
		return trim(object);
	}
	/**deprecated 用trim代替，这个保留到17.0
	 */
	public static String getTrimedString(CharSequence cs) {
		return trim(get(cs));
	}
	/**deprecated 用trim代替，这个保留到17.0
	 */
	public static String getTrimedString(String s) {
		return trim(s);
	}

	//获取去掉前后空格后的string>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>




	//获取去掉所有空格后的string <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	/**获取去掉所有空格后的string,为null则返回""
	 * @param tv
	 * @return
	 */
	public static String noBlank(TextView tv) {
		return noBlank(get(tv));
	}
	/**获取去掉所有空格后的string,为null则返回""
	 * @param object
	 * @return
	 */
	public static String noBlank(Object object) {
		return noBlank(get(object));
	}
	/**获取去掉所有空格后的string,为null则返回""
	 * @param cs
	 * @return
	 */
	public static String noBlank(CharSequence cs) {
		return noBlank(get(cs));
	}
	/**获取去掉所有空格后的string,为null则返回""
	 * @param s
	 * @return
	 */
	public static String noBlank(String s) {
		return get(s).replaceAll(" ", "");
	}


	/**deprecated 用noBlank代替，这个保留到17.0
	 */
	public static String getNoBlankString(TextView tv) {
		return noBlank(get(tv));
	}
	/**deprecated 用noBlank代替，这个保留到17.0
	 */
	public static String getNoBlankString(Object object) {
		return noBlank(get(object));
	}
	/**deprecated 用noBlank代替，这个保留到17.0
	 */
	public static String getNoBlankString(CharSequence cs) {
		return noBlank(get(cs));
	}
	/**deprecated 用noBlank代替，这个保留到17.0
	 */
	public static String getNoBlankString(String s) {
		return noBlank(s);
	}

	//获取去掉所有空格后的string >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


	//获取string的长度<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	/**获取string的长度,为null则返回0
	 * @param tv
	 * @return
	 */
	public static int length(TextView tv) {
		return length(get(tv));
	}
	/**获取string的长度,为null则返回0
	 * @param object
	 * @return
	 */
	public static int length(Object object) {
		return length(get(object));
	}
	/**获取string的长度,为null则返回0
	 * @param cs
	 * @return
	 */
	public static int length(CharSequence cs) {
		return length(get(cs));
	}
	/**获取string的长度,为null则返回0
	 * @param s
	 * @return
	 */
	public static int length(String s) {
		return get(s).length();
	}


	/**deprecated 用length代替，这个保留到17.0
	 */
	public static int getLength(TextView tv, boolean trim) {
		return getLength(get(tv), trim);
	}
	/**deprecated 用length代替，这个保留到17.0
	 */
	public static int getLength(Object object, boolean trim) {
		return getLength(get(object), trim);
	}
	/**deprecated 用length代替，这个保留到17.0
	 */
	public static int getLength(CharSequence cs, boolean trim) {
		return getLength(get(cs), trim);
	}
	/**deprecated 用length代替，这个保留到17.0
	 */
	public static int getLength(String s, boolean trim) {
		s = trim ? getTrimedString(s) : s;
		return length(s);
	}

	//获取string的长度>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


	//判断字符是否为空 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	/**判断字符是否为空
	 * trim = true
	 * @param s
	 * @return
	 */
	public static boolean isEmpty(String s) {
		return isEmpty(s, true);
	}
	/**判断字符是否为空
	 * @param tv
	 * @param trim
	 * @return
	 */
	public static boolean isEmpty(TextView tv, boolean trim) {
		return isEmpty(get(tv), trim);
	}
	/**判断字符是否为空
	 * @param object
	 * @param trim
	 * @return
	 */
	public static boolean isEmpty(Object object, boolean trim) {
		return isEmpty(get(object), trim);
	}
	/**判断字符是否为空
	 * @param cs
	 * @param trim
	 * @return
	 */
	public static boolean isEmpty(CharSequence cs, boolean trim) {
		return isEmpty(get(cs), trim);
	}
	/**判断字符是否为空
	 * @param s
	 * @param trim
	 * @return
	 */
	public static boolean isEmpty(String s, boolean trim) {
		//		Log.i(TAG, "isEmpty   s = " + s);
		if (s == null) {
			return true;
		}
		if (trim) {
			s = s.trim();
		}
		if (s.length() <= 0) {
			return true;
		}

		currentString = s;

		return false;
	}
	//判断字符是否为空 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


    //判断字符是否非空 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	/**判断字符是否非空
	 * @param tv
	 * @param trim
	 * @return
	 */
	public static boolean isNotEmpty(TextView tv, boolean trim) {
		return isNotEmpty(get(tv), trim);
	}

	public static boolean isNotEmpty(TextView tv, boolean trim, String msg) {
		boolean notEmpty = isNotEmpty(get(tv), trim);
		if(!notEmpty) {
			ToastUtils.showToast(BApplication.getContext(), msg);
		}
		return notEmpty;
	}

	/**判断字符是否非空
	 * @param object
	 * @param trim
	 * @return
	 */
	public static boolean isNotEmpty(Object object, boolean trim) {
		return isNotEmpty(get(object), trim);
	}
	/**判断字符是否非空
	 * @param cs
	 * @param trim
	 * @return
	 */
	public static boolean isNotEmpty(CharSequence cs, boolean trim) {
		return isNotEmpty(get(cs), trim);
	}
	/**判断字符是否非空
	 * @param s
	 * @param trim
	 * @return
	 */
	public static boolean isNotEmpty(String s, boolean trim) {
		return ! isEmpty(s, trim);
	}

	//判断字符是否非空 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


	//判断字符类型 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	//判断手机格式是否正确
	public static boolean isPhone(String phone) {
		if (isEmpty(phone, true)) {
			return false;
		}

		Pattern p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0-2,5-9])|(17[0-9]))\\d{8}$");

		currentString = phone;

		return p.matcher(phone).matches();
	}
	//判断email格式是否正确
	public static boolean isEmail(String email) {
		if (isEmpty(email, true)) {
			return false;
		}

		String str = "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
		Pattern p = Pattern.compile(str);

		currentString = email;

		return p.matcher(email).matches();
	}

	/**deprecated，保留到17.0
	 */
	public static boolean isNumer(String number) {
		return isNumber(number);
	}
	//判断是否全是数字
	public static boolean isNumber(String number) {
		if (isEmpty(number, true)) {
			return false;
		}

		Pattern pattern = Pattern.compile("[0-9]*");
		Matcher isNum = pattern.matcher(number);
		if (isNum.matches() == false) {
			return false;
		}

		currentString = number;

		return true;
	}


	public static boolean isDouble(String value) {
		try {
			Double.parseDouble(value);
			if (value.contains("."))
				return true;
			return false;
		} catch (NumberFormatException e) {
			return false;
		}
	}

	/**判断字符类型是否是号码或字母
	 * @param s
	 * @return
	 */
	public static boolean isNumberOrAlpha(String s) {
		if (s == null) {
			Log.e(TAG, "isNumberOrAlpha  s == null >> return false;");
			return false;
		}
		Pattern pNumber = Pattern.compile("[0-9]*");
		Matcher mNumber;
		Pattern pAlpha = Pattern.compile("[a-zA-Z]");
		Matcher mAlpha;
		for (int i = 0; i < s.length(); i++) {
			mNumber = pNumber.matcher(s.substring(i, i+1));
			mAlpha = pAlpha.matcher(s.substring(i, i+1));
			if(! mNumber.matches() && ! mAlpha.matches()){
				return false;
			}
		}

		currentString = s;
		return true;
	}

	/**判断字符类型是否是身份证号
	 * @param idCard
	 * @return
	 */
	public static boolean isIDCard(String idCard) {
		if (isNumberOrAlpha(idCard) == false) {
			return false;
		}
		idCard = get(idCard);
		if (idCard.length() == 15) {
			Log.w(TAG, "isIDCard idCard.length() == 15 old IDCard");
			currentString = idCard;
			return true;
		}
		if (idCard.length() == 18) {
			currentString = idCard;
			return true;
		}

		return false;
	}
	/**判断字符类型是否是邮箱
	 * @param idCard
	 * @return
	 */
	public static boolean isEmail1(String idCard) {
		if (isNumberOrAlpha(idCard) == false) {
			return false;
		}
		idCard = get(idCard);
		if (idCard.length() == 15) {
			Log.w(TAG, "isIDCard idCard.length() == 15 old IDCard");
			currentString = idCard;
			return true;
		}
		if (idCard.length() == 18) {
			currentString = idCard;
			return true;
		}

		return false;
	}

	public static final String HTTP = "http";
	public static final String URL_PREFIX = "http://";
	public static final String URL_PREFIXs = "https://";
	public static final String URL_STAFFIX = URL_PREFIX;
	public static final String URL_STAFFIXs = URL_PREFIXs;
	/**判断字符类型是否是网址
	 * @param url
	 * @return
	 */
	public static boolean isUrl(String url) {
		if (isEmpty(url, true)) {
			return false;
		} else if (! url.startsWith(URL_PREFIX) && ! url.startsWith(URL_PREFIXs)) {
			return false;
		}

		currentString = url;
		return true;
	}

	public static final String FILE_PATH_PREFIX = "file://";
	/**判断文件路径是否存在
	 * @param path
	 * @return
	 */
	public static boolean isFilePathExist(String path) {
		return StringUtil.isFilePath(path) && new File(path).exists();
	}
	/**判断字符类型是否是路径
	 * @param path
	 * @return
	 */
	public static boolean isFilePath(String path) {
		if (isEmpty(path, true)) {
			return false;
		}

		if (! path.contains(".") || path.endsWith(".")) {
			return false;
		}

		currentString = path;

		return true;
	}

	//判断字符类型 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


	//提取特殊字符<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	/**去掉string内所有非数字类型字符
	 * @param tv
	 * @return
	 */
	public static String getNumber(TextView tv) {
		return getNumber(get(tv));
	}
	/**去掉string内所有非数字类型字符
	 * @param object
	 * @return
	 */
	public static String getNumber(Object object) {
		return getNumber(get(object));
	}
	/**去掉string内所有非数字类型字符
	 * @param cs
	 * @return
	 */
	public static String getNumber(CharSequence cs) {
		return getNumber(get(cs));
	}
	/**去掉string内所有非数字类型字符
	 * @param s
	 * @return
	 */
	public static String getNumber(String s) {
		if (isEmpty(s, true)) {
			return "";
		}

		String numberString = "";
		String single;
		for (int i = 0; i < s.length(); i++) {
			single = s.substring(i, i + 1);
			if (isNumer(single)) {
				numberString += single;
			}
		}

		return numberString;
	}

	//提取特殊字符>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	//校正（自动补全等）字符串<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	/**获取网址，自动补全
	 * @param tv
	 * @return
	 */
	public static String getCorrectUrl(TextView tv) {
		return getCorrectUrl(get(tv));
	}
	/**获取网址，自动补全
	 * @param url
	 * @return
	 */
	public static String getCorrectUrl(String url) {
		Log.i(TAG, "getCorrectUrl : \n" + url);
		if (isEmpty(url, true)) {
			return "";
		}

//		if (! url.endsWith("/") && ! url.endsWith(".html")) {
//			url = url + "/";
//		}

		return isUrl(url) ? url : URL_PREFIX + url;
	}

	/**获取去掉所有 空格 、"-" 、"+86" 后的phone
	 * @param tv
	 * @return
	 */
	public static String getCorrectPhone(TextView tv) {
		return getCorrectPhone(get(tv));
	}
	/**获取去掉所有 空格 、"-" 、"+86" 后的phone
	 * @param phone
	 * @return
	 */
	public static String getCorrectPhone(String phone) {
		if (isEmpty(phone, true)) {
			return "";
		}

		phone = noBlank(phone);
		phone = phone.replaceAll("-", "");
		if (phone.startsWith("+86")) {
			phone = phone.substring(3);
		}
		return phone;
	}


	/**获取邮箱，自动补全
	 * @param tv
	 * @return
	 */
	public static String getCorrectEmail(TextView tv) {
		return getCorrectEmail(get(tv));
	}
	/**获取邮箱，自动补全
	 * @param email
	 * @return
	 */
	public static String getCorrectEmail(String email) {
		if (isEmpty(email, true)) {
			return "";
		}

		email = noBlank(email);
		if (isEmail(email) == false && ! email.endsWith(".com")) {
			email += ".com";
		}

		return email;
	}


	public static final int PRICE_FORMAT_DEFAULT = 0;
	public static final int PRICE_FORMAT_PREFIX = 1;
	public static final int PRICE_FORMAT_SUFFIX = 2;
	public static final int PRICE_FORMAT_PREFIX_WITH_BLANK = 3;
	public static final int PRICE_FORMAT_SUFFIX_WITH_BLANK = 4;
	public static final String[] PRICE_FORMATS = {
			"", "￥", "元", "￥ ", " 元"
	};

	/**获取价格，保留两位小数
	 * @param price
	 * @return
	 */
	public static String getPrice(String price) {
		return getPrice(price, PRICE_FORMAT_DEFAULT);
	}
	/**获取价格，保留两位小数
	 * @param price
	 * @param formatType 添加单位（元）
	 * @return
	 */
	public static String getPrice(String price, int formatType) {
		if (isEmpty(price, true)) {
			return getPrice(0, formatType);
		}

		//单独写到getCorrectPrice? <<<<<<<<<<<<<<<<<<<<<<
		String correctPrice = "";
		String s;
		for (int i = 0; i < price.length(); i++) {
			s = price.substring(i, i + 1);
			if (".".equals(s) || isNumer(s)) {
				correctPrice += s;
			}
		}
		//单独写到getCorrectPrice? >>>>>>>>>>>>>>>>>>>>>>

		Log.i(TAG, "getPrice  <<<<<<<<<<<<<<<<<< correctPrice =  " + correctPrice);
		if (correctPrice.contains(".")) {
//			if (correctPrice.startsWith(".")) {
//				correctPrice = 0 + correctPrice;
//			}
			if (correctPrice.endsWith(".")) {
				correctPrice = correctPrice.replaceAll(".", "");
			}
		}

		Log.i(TAG, "getPrice correctPrice =  " + correctPrice + " >>>>>>>>>>>>>>>>");
		return isEmpty(correctPrice, true) ? getPrice(0, formatType) : getPrice(new BigDecimal(0 + correctPrice), formatType);
	}
	/**获取价格，保留两位小数
	 * @param price
	 * @return
	 */
	public static String getPrice(BigDecimal price) {
		return getPrice(price, PRICE_FORMAT_DEFAULT);
	}
	/**获取价格，保留两位小数
	 * @param price
	 * @return
	 */
	public static String getPrice(double price) {
		return getPrice(price, PRICE_FORMAT_DEFAULT);
	}
	/**获取价格，保留两位小数
	 * @param price
	 * @param formatType 添加单位（元）
	 * @return
	 */
	public static String getPrice(BigDecimal price, int formatType) {
		return getPrice(price == null ? 0 : price.doubleValue(), formatType);
	}
	/**获取价格，保留两位小数
	 * @param price
	 * @param formatType 添加单位（元）
	 * @return
	 */
	public static String getPrice(double price, int formatType) {
		String s = new DecimalFormat("#########0.00").format(price);
		switch (formatType) {
			case PRICE_FORMAT_PREFIX:
				return PRICE_FORMATS[PRICE_FORMAT_PREFIX] + s;
			case PRICE_FORMAT_SUFFIX:
				return s + PRICE_FORMATS[PRICE_FORMAT_SUFFIX];
			case PRICE_FORMAT_PREFIX_WITH_BLANK:
				return PRICE_FORMATS[PRICE_FORMAT_PREFIX_WITH_BLANK] + s;
			case PRICE_FORMAT_SUFFIX_WITH_BLANK:
				return s + PRICE_FORMATS[PRICE_FORMAT_SUFFIX_WITH_BLANK];
			default:
				return s;
		}
	}

	public static String getResourceStr(@StringRes int id, Object... args) {
		String temp4 = BApplication.getContext().getResources().getString(id);
		String total = String.format(temp4,args);
		return total;
	}
	public interface NavigationListener {
		void show();

		void hide();
	}
	//虚拟导航栏显示/隐藏
	public static void setNavigationListener(final Context context, final View rootView, final NavigationListener navigationListener, final Window window) {
		System.out.println("onGlobalLayout111");
		if (rootView == null || navigationListener == null) {
			return;
		}
		rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
			boolean isShow = false;

			@Override
			public void onGlobalLayout() {
				System.out.println("onGlobalLayout");
				boolean show;
				Display display = window.getWindowManager().getDefaultDisplay();
				Point point = new Point();
				if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
					display.getRealSize(point);
				}

				View decorView = window.getDecorView();
				Configuration conf = context.getResources().getConfiguration();
				if (Configuration.ORIENTATION_LANDSCAPE == conf.orientation) {
					View contentView = decorView.findViewById(android.R.id.content);
					show = (point.x != contentView.getWidth());
				} else {
					Rect rect = new Rect();
					decorView.getWindowVisibleDisplayFrame(rect);
					show = (rect.bottom != point.y);
				}
				if (show) {
					if (isShow) {
						return;
					}
					isShow = show;
					//显示虚拟按键
					if (navigationListener != null) {
						navigationListener.show();
					}
				} else {
					if (!isShow) {
						return;
					}
					isShow = show;
					System.out.println("onGlobalLayout:hide");
					if (navigationListener != null) {
						navigationListener.hide();
					}
				}
			}
		});
	}
	/**
	 * 获取导航栏高度
	 *
	 * @param context
	 * @return
	 */
	public static int getDaoHangHeight(Context context) {
		int result = 0;
		int resourceId = 0;
		int rid = context.getResources().getIdentifier("config_showNavigationBar", "bool", "android");
		if (rid != 0) {
			resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
			return context.getResources().getDimensionPixelSize(resourceId);
		} else
			return 0;
	}
	//校正（自动补全等）字符串>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


	public static boolean isMobileNumber(String mobiles) {
		String telRegex = "^((13[0-9])|(15[^4])|(18[0-9])|(17[0-8])|(147,145))\\d{8}$";
		return mobiles.matches(telRegex);
	}


	private static int n = 0;// 原Str拥有的字符个数
	private static SpannableString spannableString;
	private static double multiple = 0;// 放大倍数

	/**
	 * 对显示的字符串进行格式化 比如输入：出生年月 输出结果：出正生正年正月
	 */
	public static String formatStr(String str) {
		if (TextUtils.isEmpty(str)) {
			return "";
		}
		n = str.length();
		if (n >= 6) {
			return str;
		}
		StringBuilder sb = new StringBuilder(str);
		for (int i = n - 1; i > 0; i--) {
			sb.insert(i, "正");
		}
		return sb.toString();
	}

	/**
	 * 对显示字符串进行格式化 比如输入：安正卓正机正器正人 输出结果：安 卓 机 器 人
	 *
	 * @param str
	 * @return     */
	public static SpannableString formatText(String str){
		if (TextUtils.isEmpty(str)) {
			return null;
		}
		str = formatStr(str);
		if (str.length()<=6){
			return null;
		}
		spannableString = new SpannableString(str);
		switch (n) {
			case 2:
				multiple = 4;
				break;
			case 3:
				multiple = 1.5;
				break;
			case 4:
				multiple =   0.66666666666666666666666666666666667;
				break;
			case 5:
				multiple = 0.25;
				break;
			default:
				break;
		}
		for (int i = 1; i < str.length(); i = i + 2)
		{
			spannableString.setSpan(new RelativeSizeSpan((float) multiple), i, i + 1, Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
			spannableString.setSpan(new ForegroundColorSpan(Color.TRANSPARENT), i, i + 1,  Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
		}
		return spannableString;
	}

	public static String getPatternText(String str) {
		String reg = "<span>([\\s\\S]*?)</span>";
		Pattern p = Pattern.compile(reg);
		str = str.replace("&nbsp;", "");
		Matcher m = p.matcher(str);
		while(m.find()) {
			String data = m.group(1).trim();
			if(!"".equals(data)) {
				return data;
			}
		}
		return "";

	}

	public static String[] secToTimes(long time) {
		String[] timeStrs = new String[3];
		if (time <= 0L) {
			timeStrs[0] = "00";
			timeStrs[1] = "00";
			timeStrs[2] = "00";
			return timeStrs;
		} else {
			int minute = (int)(time / 60L);
			int second;
			if (minute < 60) {
				second = (int)(time % 60L);
				timeStrs[0] = "00";
				timeStrs[1] = unitFormat(minute);
				timeStrs[2] = unitFormat(second);
			} else {
				int hour = minute / 60;
				/*if (hour > 99) {
					timeStrs[0] = "99";
					timeStrs[1] = "59";
					timeStrs[2] = "59";
					return timeStrs;
				}
*/
				minute %= 60;
				second = (int)(time - (long)(hour * 3600) - (long)(minute * 60));
				timeStrs[0] = unitFormat(hour);
				timeStrs[1] = unitFormat(minute);
				timeStrs[2] = unitFormat(second);
			}

			return timeStrs;
		}
	}

	private static String unitFormat(int i) {
		String retStr;
		if (i >= 0 && i < 10) {
			retStr = "0" + Integer.toString(i);
		} else {
			retStr = "" + i;
		}

		return retStr;
	}

	public static void setPoint(final EditText editText, int DECIMAL_DIGITS) {
		editText.addTextChangedListener(new TextWatcher() {
			@Override
			public void onTextChanged(CharSequence s, int start, int before,int count) {
				if (s.toString().contains(".")) {
					if (s.length() - 1 - s.toString().indexOf(".") > DECIMAL_DIGITS) {
						s = s.toString().subSequence(0,
								s.toString().indexOf(".") + DECIMAL_DIGITS+1);
						editText.setText(s);
						editText.setSelection(s.length());
					}
				}
				if (s.toString().trim().substring(0).equals(".")) {
					s = "0" + s;
					editText.setText(s);
					editText.setSelection(2);
				}
				if (s.toString().startsWith("0")
						&& s.toString().trim().length() > 1) {
					if (!s.toString().substring(1, 2).equals(".")) {
						editText.setText(s.subSequence(0, 1));
						editText.setSelection(1);
						return;
					}
				}
			}
			@Override
			public void beforeTextChanged(CharSequence s, int start, int count,int after) {
			}
			@Override
			public void afterTextChanged(Editable s) {
			}
		});
	}

}
